/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.attachment;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.block.portal.PortalClientUtil;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.miscellaneous.CloudMinion;
import com.aetherteam.aether.entity.miscellaneous.Parachute;
import com.aetherteam.aether.entity.passive.Aerbunny;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.miscellaneous.ParachuteItem;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.aether.network.packet.clientbound.CloudMinionPacket;
import com.aetherteam.aether.network.packet.clientbound.RemountAerbunnyPacket;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aether.perk.data.ClientDeveloperGlowPerkData;
import com.aetherteam.aether.perk.data.ClientHaloPerkData;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.aetherfabric.network.PacketDistributor;
import com.aetherteam.nitrogen.attachment.INBTSynchable;
import com.aetherteam.nitrogen.network.packet.SyncPacket;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3468;
import net.minecraft.class_4844;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class AetherPlayerAttachment
implements INBTSynchable {
    private static final class_2960 LIFE_SHARD_HEALTH_ID = class_2960.method_60655((String)"aether", (String)"life_shard_max_health");
    private boolean canGetPortal = true;
    private boolean canSpawnInAether = true;
    public float portalIntensity;
    public float oPortalIntensity;
    private boolean isHitting;
    private boolean isMoving;
    private boolean isJumping;
    private boolean isGravititeJumpActive;
    private boolean seenSunSpiritDialogue;
    private int goldenDartCount;
    private int poisonDartCount;
    private int enchantedDartCount;
    private int removeGoldenDartTime;
    private int removePoisonDartTime;
    private int removeEnchantedDartTime;
    private int remedyStartDuration;
    private int impactedMaximum;
    private int impactedTimer;
    private boolean performVampireHealing;
    @Nullable
    private Aerbunny mountedAerbunny;
    private Optional<class_2487> mountedAerbunnyTag = Optional.empty();
    private Optional<UUID> lastRiddenMoa = Optional.empty();
    private final List<CloudMinion> cloudMinions = new ArrayList<CloudMinion>(2);
    private int wingRotationO;
    private int wingRotation;
    private int invisibilityAttackCooldown;
    private boolean attackedWithInvisibility;
    private boolean invisibilityEnabled = true;
    private boolean wearingInvisibilityCloak;
    private static final int FLIGHT_TIMER_MAX = 52;
    private static final float FLIGHT_MODIFIER_MAX = 15.0f;
    private int flightTimer;
    private float flightModifier = 1.0f;
    private double neptuneSubmergeLength;
    private double phoenixSubmergeLength;
    private static final int OBSIDIAN_TIMER_MAX = 20;
    private int obsidianConversionTime;
    private float savedHealth = 0.0f;
    private int lifeShards;
    private static final class_2960 LOGOMARKS = class_2960.method_60655((String)"aether", (String)"logomarks");
    private static final class_2583 DISCORD = class_2583.field_24360.method_36139(5793266).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://discord.gg/aethermod")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"https://discord.gg/aethermod")));
    private static final class_2583 PATREON = class_2583.field_24360.method_36139(16728653).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.patreon.com/TheAetherTeam")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"https://www.patreon.com/TheAetherTeam")));
    private boolean canShowPatreonMessage = true;
    private int loginsUntilPatreonMessage = -1;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setHitting", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setHitting((Boolean)object), this::isHitting)), Map.entry("setMoving", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setMoving((Boolean)object), this::isMoving)), Map.entry("setJumping", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setJumping((Boolean)object), this::isJumping)), Map.entry("setGravititeJumpActive", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setGravititeJumpActive((Boolean)object), this::isGravititeJumpActive)), Map.entry("setGoldenDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setGoldenDartCount((Integer)object), this::getGoldenDartCount)), Map.entry("setPoisonDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setPoisonDartCount((Integer)object), this::getPoisonDartCount)), Map.entry("setEnchantedDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setEnchantedDartCount((Integer)object), this::getEnchantedDartCount)), Map.entry("setRemedyStartDuration", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setRemedyStartDuration((Integer)object), this::getRemedyStartDuration)), Map.entry("setAttackedWithInvisibility", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setAttackedWithInvisibility((Boolean)object), this::attackedWithInvisibility)), Map.entry("setInvisibilityEnabled", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setInvisibilityEnabled((Boolean)object), this::isInvisibilityEnabled)), Map.entry("setWearingInvisibilityCloak", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setWearingInvisibilityCloak((Boolean)object), this::isWearingInvisibilityCloak)), Map.entry("setLifeShardCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setLifeShardCount((Integer)object), this::getLifeShardCount)), Map.entry("setLastRiddenMoa", Triple.of((Object)INBTSynchable.Type.UUID, object -> this.setLastRiddenMoa((UUID)object), this::getLastRiddenMoa)), Map.entry("setShouldSyncBetweenClients", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setShouldSyncBetweenClients((Boolean)object), this::shouldSyncBetweenClients)));
    private boolean shouldSyncAfterJoin;
    private boolean shouldSyncBetweenClients;
    public static final Codec<AetherPlayerAttachment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("can_get_portal").forGetter(AetherPlayerAttachment::canGetPortal), (App)Codec.BOOL.fieldOf("can_spawn_in_aether").forGetter(AetherPlayerAttachment::canSpawnInAether), (App)Codec.FLOAT.fieldOf("saved_health").forGetter(AetherPlayerAttachment::getSavedHealth), (App)Codec.INT.fieldOf("life_shard_count").forGetter(AetherPlayerAttachment::getLifeShardCount), (App)Codec.BOOL.fieldOf("seen_sun_spirit").forGetter(AetherPlayerAttachment::hasSeenSunSpiritDialogue), (App)Codec.INT.fieldOf("remedy_start_duration").forGetter(AetherPlayerAttachment::getRemedyStartDuration), (App)class_2487.field_25128.optionalFieldOf("mounted_aerbunny").forGetter(AetherPlayerAttachment::getMountedAerbunnyTag), (App)class_4844.field_25122.optionalFieldOf("last_ridden_moa").forGetter(o -> o.lastRiddenMoa), (App)Codec.BOOL.fieldOf("show_patreon_message").forGetter(o -> o.canShowPatreonMessage), (App)Codec.INT.fieldOf("logins_until_patreon_message").forGetter(o -> o.loginsUntilPatreonMessage)).apply((Applicative)instance, AetherPlayerAttachment::new));

    public AetherPlayerAttachment() {
    }

    public AetherPlayerAttachment(boolean portal, boolean spawnInAether, float savedHealth, int lifeShards, boolean seenSunSpirit, int remedyDuration, Optional<class_2487> mountedAerbunnyTag, Optional<UUID> lastRiddenMoa, boolean showPatreonMessage, int loginUntilMessage) {
        this.setCanGetPortal(portal);
        this.setCanSpawnInAether(spawnInAether);
        this.setSavedHealth(savedHealth);
        this.setLifeShardCount(lifeShards);
        this.setSeenSunSpiritDialogue(seenSunSpirit);
        this.setRemedyStartDuration(remedyDuration);
        this.setMountedAerbunnyTag(mountedAerbunnyTag);
        this.setLastRiddenMoa(lastRiddenMoa.orElse(null));
        this.canShowPatreonMessage = showPatreonMessage;
        this.loginsUntilPatreonMessage = loginUntilMessage;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public void onLogout(class_1657 player) {
        this.handleLogoutSavedHealth(player);
    }

    public void onLogin(class_1657 player) {
        this.handleGivePortal(player);
        this.remountAerbunny(player);
        this.handlePatreonMessage(player);
        this.shouldSyncAfterJoin = true;
        ServerPerkData.MOA_SKIN_INSTANCE.syncFromServer(player);
        ServerPerkData.HALO_INSTANCE.syncFromServer(player);
        ServerPerkData.DEVELOPER_GLOW_INSTANCE.syncFromServer(player);
    }

    public void onJoinLevel(class_1657 player) {
        if (player.method_37908().method_8608()) {
            CustomizationsOptions.INSTANCE.load();
            this.setSynched(player.method_5628(), INBTSynchable.Direction.SERVER, "setShouldSyncBetweenClients", true);
        }
    }

    public void handleRespawn(boolean wasDeath) {
        if (wasDeath) {
            this.setRemedyStartDuration(0);
        }
        this.shouldSyncAfterJoin = true;
    }

    public void onUpdate(class_1657 player) {
        this.syncAfterJoin(player);
        this.syncClients(player);
        this.handleAetherPortal(player);
        this.activateParachute(player);
        this.handleRemoveDarts(player);
        this.removeRemedyDuration(player);
        this.tickDownProjectileImpact(player);
        this.handleWingRotation(player);
        this.handleAttackCooldown(player);
        this.handleVampireHealing(player);
        this.checkToRemoveAerbunny(player);
        this.checkToRemoveCloudMinions();
        this.handleSavedHealth(player);
        this.handleLifeShardModifier(player);
        ClientMoaSkinPerkData.INSTANCE.syncFromClient(player);
        ClientHaloPerkData.INSTANCE.syncFromClient(player);
        ClientDeveloperGlowPerkData.INSTANCE.syncFromClient(player);
    }

    private void syncAfterJoin(class_1657 player) {
        if (this.shouldSyncAfterJoin) {
            this.forceSync(player.method_5628(), INBTSynchable.Direction.CLIENT);
            this.shouldSyncAfterJoin = false;
        }
    }

    private void syncClients(class_1657 player) {
        if (this.shouldSyncBetweenClients()) {
            MinecraftServer server;
            if (!player.method_37908().method_8608() && (server = player.method_37908().method_8503()) != null) {
                class_3324 playerList = server.method_3760();
                for (class_3222 serverPlayer : playerList.method_14571()) {
                    if (serverPlayer.method_5667().equals(player.method_5667())) continue;
                    ((AetherPlayerAttachment)player.getAttachedOrCreate(AetherDataAttachments.AETHER_PLAYER)).forceSync(player.method_5628(), INBTSynchable.Direction.CLIENT);
                }
            }
            this.setShouldSyncBetweenClients(false);
        }
    }

    private void handleAetherPortal(class_1657 player) {
        if (player.method_37908().method_8608()) {
            PortalClientUtil.handleAetherPortal(player, this);
        }
    }

    public void setCanSpawnInAether(boolean canSpawnInAether) {
        this.canSpawnInAether = canSpawnInAether;
    }

    public boolean canSpawnInAether() {
        return this.canSpawnInAether;
    }

    public float getPortalIntensity() {
        return this.portalIntensity;
    }

    public float getOldPortalIntensity() {
        return this.oPortalIntensity;
    }

    private void handleGivePortal(class_1657 player) {
        if (((Boolean)AetherConfig.COMMON.start_with_portal.get()).booleanValue()) {
            this.givePortalItem(player);
        } else {
            this.setCanGetPortal(false);
        }
    }

    private void activateParachute(class_1657 player) {
        class_1661 inventory = player.method_31548();
        class_1937 level = player.method_37908();
        if (!player.method_7337() && !player.method_5715() && !player.method_6128() && !player.method_5765() && player.method_18798().method_10214() < -1.5 && inventory.method_7382(AetherTags.Items.DEPLOYABLE_PARACHUTES)) {
            for (class_1799 stack : inventory.field_7547) {
                ParachuteItem parachuteItem;
                Parachute parachute;
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof ParachuteItem) || (parachute = (Parachute)(parachuteItem = (ParachuteItem)class_17922).getParachuteEntity().get().method_5883(level)) == null) continue;
                parachute.method_5814(player.method_23317(), player.method_23318() - 1.0, player.method_23321());
                parachute.method_18799(player.method_18798());
                if (!level.method_8608()) {
                    level.method_8649((class_1297)parachute);
                    player.method_5804((class_1297)parachute);
                    stack.method_7970(1, (class_1309)player, class_1304.field_6173);
                }
                parachute.spawnExplosionParticle();
                break;
            }
        }
    }

    private void handleRemoveDarts(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            if (this.getGoldenDartCount() > 0) {
                if (this.removeGoldenDartTime <= 0) {
                    this.removeGoldenDartTime = 20 * (30 - this.getGoldenDartCount());
                }
                --this.removeGoldenDartTime;
                if (this.removeGoldenDartTime <= 0) {
                    this.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setGoldenDartCount", this.getGoldenDartCount() - 1);
                }
            }
            if (this.getPoisonDartCount() > 0) {
                if (this.removePoisonDartTime <= 0) {
                    this.removePoisonDartTime = 20 * (30 - this.getPoisonDartCount());
                }
                --this.removePoisonDartTime;
                if (this.removePoisonDartTime <= 0) {
                    this.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setPoisonDartCount", this.getPoisonDartCount() - 1);
                }
            }
            if (this.getEnchantedDartCount() > 0) {
                if (this.removeEnchantedDartTime <= 0) {
                    this.removeEnchantedDartTime = 20 * (30 - this.getEnchantedDartCount());
                }
                --this.removeEnchantedDartTime;
                if (this.removeEnchantedDartTime <= 0) {
                    this.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setEnchantedDartCount", this.getEnchantedDartCount() - 1);
                }
            }
        }
    }

    private void removeRemedyDuration(class_1657 player) {
        if (this.remedyStartDuration > 0 && !player.method_6059(AetherEffects.REMEDY.aetherFabric$getDelegate())) {
            this.remedyStartDuration = 0;
        }
    }

    private void tickDownProjectileImpact(class_1657 player) {
        if (player.method_37908().method_8608()) {
            if (this.getProjectileImpactedTimer() > 0) {
                this.setProjectileImpactedTimer(this.getProjectileImpactedTimer() - 1);
            } else {
                this.setProjectileImpactedMaximum(0);
                this.setProjectileImpactedTimer(0);
            }
        }
    }

    private void handleWingRotation(class_1657 player) {
        if (player.method_37908().method_8608()) {
            this.wingRotationO = this.getWingRotation();
            this.wingRotation = EquipmentUtil.hasFullValkyrieSet((class_1309)player) ? player.field_6012 : 0;
        }
    }

    private void handleAttackCooldown(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            if (this.attackedWithInvisibility()) {
                --this.invisibilityAttackCooldown;
                if (this.invisibilityAttackCooldown <= 0) {
                    this.setSynched(player.method_5628(), INBTSynchable.Direction.CLIENT, "setAttackedWithInvisibility", false);
                }
            } else {
                this.invisibilityAttackCooldown = (Integer)AetherConfig.SERVER.invisibility_visibility_time.get();
            }
        }
    }

    private void handleVampireHealing(class_1657 player) {
        if (!player.method_37908().method_8608() && this.performVampireHealing()) {
            player.method_6025(1.0f);
            this.setVampireHealing(false);
        }
    }

    private void checkToRemoveAerbunny(class_1657 player) {
        if (!(this.getMountedAerbunny() == null || this.getMountedAerbunny().method_5805() && player.method_5805())) {
            this.setMountedAerbunny(null);
        }
    }

    public void removeAerbunny() {
        if (this.getMountedAerbunny() != null) {
            Aerbunny aerbunny = this.getMountedAerbunny();
            class_2487 nbt = new class_2487();
            aerbunny.method_5662(nbt);
            this.setMountedAerbunnyTag(Optional.of(nbt));
            aerbunny.method_5848();
            aerbunny.method_31745(class_1297.class_5529.field_27001);
        }
    }

    public void remountAerbunny(class_1657 player) {
        if (this.getMountedAerbunnyTag().isPresent()) {
            if (!player.method_37908().method_8608()) {
                Aerbunny aerbunny = new Aerbunny((class_1299<? extends Aerbunny>)AetherEntityTypes.AERBUNNY.get(), player.method_37908());
                aerbunny.method_5651(this.getMountedAerbunnyTag().get());
                player.method_37908().method_8649((class_1297)aerbunny);
                aerbunny.method_5804((class_1297)player);
                this.setMountedAerbunny(aerbunny);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    PacketDistributor.sendToPlayer(serverPlayer, new RemountAerbunnyPacket(player.method_5628(), aerbunny.method_5628()), new class_8710[0]);
                }
            }
            this.setMountedAerbunnyTag(Optional.empty());
        }
    }

    private void checkToRemoveCloudMinions() {
        this.getCloudMinions().removeIf(cloudMinion -> !cloudMinion.method_5805());
    }

    private void handleSavedHealth(class_1657 player) {
        class_1324 health;
        if (this.getSavedHealth() > 0.0f && (health = player.method_5996(class_5134.field_23716)) != null && health.method_6196(this.getLifeShardHealthAttributeModifier().comp_2447())) {
            player.method_6033(Math.min(this.getSavedHealth(), player.method_6063()));
            this.setSavedHealth(0.0f);
        }
    }

    private void handleLifeShardModifier(class_1657 player) {
        if (!player.method_37908().method_8608()) {
            class_1324 health = player.method_5996(class_5134.field_23716);
            class_1322 lifeShardHealth = this.getLifeShardHealthAttributeModifier();
            if (health != null) {
                if (health.method_6196(lifeShardHealth.comp_2447())) {
                    health.method_6200(lifeShardHealth.comp_2447());
                }
                health.method_26835(lifeShardHealth);
            }
        }
    }

    private void handleLogoutSavedHealth(class_1657 player) {
        class_1324 health = player.method_5996(class_5134.field_23716);
        if (health != null && health.method_6196(this.getLifeShardHealthAttributeModifier().comp_2447())) {
            this.setSavedHealth(player.method_6032());
        }
    }

    private void handlePatreonMessage(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (((Boolean)AetherConfig.COMMON.show_patreon_message.get()).booleanValue() && this.canShowPatreonMessage) {
                if (this.loginsUntilPatreonMessage < 0 && serverPlayer.method_37908().method_27983() == AetherDimensions.AETHER_LEVEL && (serverPlayer.method_14248().method_15025(class_3468.field_15403.method_14956(AetherEntityTypes.SLIDER.get())) > 0 || serverPlayer.method_14248().method_15025(class_3468.field_15403.method_14956(AetherEntityTypes.VALKYRIE_QUEEN.get())) > 0 || serverPlayer.method_14248().method_15025(class_3468.field_15403.method_14956(AetherEntityTypes.SUN_SPIRIT.get())) > 0)) {
                    this.loginsUntilPatreonMessage = serverPlayer.method_59922().method_43048(2);
                }
                if (this.loginsUntilPatreonMessage == 0) {
                    this.sendPatreonMessage(serverPlayer);
                    this.canShowPatreonMessage = false;
                    AetherConfig.COMMON.show_patreon_message.set((Object)false);
                    AetherConfig.COMMON.show_patreon_message.save();
                } else if (this.loginsUntilPatreonMessage > 0) {
                    --this.loginsUntilPatreonMessage;
                }
            } else if (!((Boolean)AetherConfig.COMMON.show_patreon_message.get()).booleanValue()) {
                this.canShowPatreonMessage = false;
            }
        }
    }

    private void sendPatreonMessage(class_3222 serverPlayer) {
        class_5250 component = class_2561.method_43471((String)"gui.aether.patreon.message");
        List<String> unlinkedBodyArray = Arrays.stream(component.getString().split("(?=(%s1))|(?<=(%s1))|(?=(%s2))|(?<=(%s2))|(?=(%s3))|(?<=(%s3))")).toList();
        List<class_5250> bodyArray = unlinkedBodyArray.stream().map(string -> switch (string) {
            case "%s1" -> class_2561.method_43470((String)"The Aether").method_10862(class_2583.field_24360.method_36139(8445183).method_10978(Boolean.valueOf(true)));
            case "%s2" -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"! ").method_10862(DISCORD.method_27704(LOGOMARKS))).method_10852((class_2561)class_2561.method_43470((String)"Discord").method_10862(DISCORD));
            case "%s3" -> class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)", ").method_10862(PATREON.method_27704(LOGOMARKS))).method_10852((class_2561)class_2561.method_43470((String)"Patreon").method_10862(PATREON));
            default -> class_2561.method_43470((String)string);
        }).toList();
        class_5250 message = class_2561.method_43470((String)"");
        bodyArray.forEach(arg_0 -> ((class_5250)message).method_10852(arg_0));
        serverPlayer.method_43496((class_2561)message);
        class_5250 note = class_2561.method_43471((String)"gui.aether.patreon.note").method_10862(class_2583.field_24360.method_36139(0x747474).method_10978(Boolean.valueOf(true)));
        serverPlayer.method_43496((class_2561)note);
    }

    public void givePortalItem(class_1657 player) {
        if (this.canGetPortal()) {
            player.method_7270(new class_1799((class_1935)AetherItems.AETHER_PORTAL_FRAME.get()));
            this.setCanGetPortal(false);
        }
    }

    public void setCanGetPortal(boolean canGetPortal) {
        this.canGetPortal = canGetPortal;
    }

    public boolean canGetPortal() {
        return this.canGetPortal;
    }

    public void setHitting(boolean isHitting) {
        this.isHitting = isHitting;
    }

    public boolean isHitting() {
        return this.isHitting;
    }

    public void setMoving(boolean isMoving) {
        this.isMoving = isMoving;
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setGravititeJumpActive(boolean isGravititeJumpActive) {
        this.isGravititeJumpActive = isGravititeJumpActive;
    }

    public boolean isGravititeJumpActive() {
        return this.isGravititeJumpActive;
    }

    public void setSeenSunSpiritDialogue(boolean seenDialogue) {
        this.seenSunSpiritDialogue = seenDialogue;
    }

    public boolean hasSeenSunSpiritDialogue() {
        return this.seenSunSpiritDialogue;
    }

    public void setGoldenDartCount(int count) {
        this.goldenDartCount = count;
    }

    public int getGoldenDartCount() {
        return this.goldenDartCount;
    }

    public void setPoisonDartCount(int count) {
        this.poisonDartCount = count;
    }

    public int getPoisonDartCount() {
        return this.poisonDartCount;
    }

    public void setEnchantedDartCount(int count) {
        this.enchantedDartCount = count;
    }

    public int getEnchantedDartCount() {
        return this.enchantedDartCount;
    }

    public void setRemedyStartDuration(int duration) {
        this.remedyStartDuration = duration;
    }

    public int getRemedyStartDuration() {
        return this.remedyStartDuration;
    }

    public void setProjectileImpactedMaximum(int projectileImpactedMaximum) {
        this.impactedMaximum = projectileImpactedMaximum;
    }

    public int getProjectileImpactedMaximum() {
        return this.impactedMaximum;
    }

    public void setProjectileImpactedTimer(int projectileImpactedTimer) {
        this.impactedTimer = projectileImpactedTimer;
    }

    public int getProjectileImpactedTimer() {
        return this.impactedTimer;
    }

    public void setVampireHealing(boolean performVampireHealing) {
        this.performVampireHealing = performVampireHealing;
    }

    public boolean performVampireHealing() {
        return this.performVampireHealing;
    }

    public void setMountedAerbunny(@Nullable Aerbunny mountedAerbunny) {
        this.mountedAerbunny = mountedAerbunny;
    }

    @Nullable
    public Aerbunny getMountedAerbunny() {
        return this.mountedAerbunny;
    }

    public void setMountedAerbunnyTag(Optional<class_2487> mountedAerbunnyTag) {
        this.mountedAerbunnyTag = mountedAerbunnyTag;
    }

    public Optional<class_2487> getMountedAerbunnyTag() {
        return this.mountedAerbunnyTag;
    }

    public void setLastRiddenMoa(@Nullable UUID lastRiddenMoa) {
        this.lastRiddenMoa = Optional.ofNullable(lastRiddenMoa);
    }

    @Nullable
    public UUID getLastRiddenMoa() {
        return this.lastRiddenMoa.orElse(null);
    }

    public void setCloudMinions(class_1657 player, CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        this.sendCloudMinionPacket(player, cloudMinionRight, cloudMinionLeft);
        this.cloudMinions.add(0, cloudMinionRight);
        this.cloudMinions.add(1, cloudMinionLeft);
    }

    public List<CloudMinion> getCloudMinions() {
        return this.cloudMinions;
    }

    public int getWingRotationO() {
        return this.wingRotationO;
    }

    public int getWingRotation() {
        return this.wingRotation;
    }

    public void setAttackedWithInvisibility(boolean attacked) {
        this.attackedWithInvisibility = attacked;
    }

    public boolean attackedWithInvisibility() {
        return this.attackedWithInvisibility;
    }

    public void setInvisibilityEnabled(boolean enabled) {
        this.invisibilityEnabled = enabled;
    }

    public boolean isInvisibilityEnabled() {
        return this.invisibilityEnabled;
    }

    public void setWearingInvisibilityCloak(boolean wearing) {
        this.wearingInvisibilityCloak = wearing;
    }

    public boolean isWearingInvisibilityCloak() {
        return this.wearingInvisibilityCloak;
    }

    public int getFlightTimerMax() {
        return 52;
    }

    public float getFlightModifierMax() {
        return 15.0f;
    }

    public void setFlightTimer(int timer) {
        this.flightTimer = timer;
    }

    public int getFlightTimer() {
        return this.flightTimer;
    }

    public void setFlightModifier(float modifier) {
        this.flightModifier = modifier;
    }

    public float getFlightModifier() {
        return this.flightModifier;
    }

    public void setSavedHealth(float health) {
        this.savedHealth = health;
    }

    public float getSavedHealth() {
        return this.savedHealth;
    }

    public void setNeptuneSubmergeLength(double length) {
        this.neptuneSubmergeLength = length;
    }

    public double getNeptuneSubmergeLength() {
        return this.neptuneSubmergeLength;
    }

    public void setPhoenixSubmergeLength(double length) {
        this.phoenixSubmergeLength = length;
    }

    public double getPhoenixSubmergeLength() {
        return this.phoenixSubmergeLength;
    }

    public int getObsidianConversionTimerMax() {
        return 20;
    }

    public void setObsidianConversionTime(int time) {
        this.obsidianConversionTime = time;
    }

    public int getObsidianConversionTime() {
        return this.obsidianConversionTime;
    }

    public void setLifeShardCount(int amount) {
        this.lifeShards = amount;
    }

    public int getLifeShardCount() {
        return this.lifeShards;
    }

    public int getLifeShardLimit() {
        return (Integer)AetherConfig.SERVER.maximum_life_shards.get();
    }

    public class_1322 getLifeShardHealthAttributeModifier() {
        return new class_1322(LIFE_SHARD_HEALTH_ID, (double)((float)this.getLifeShardCount() * 2.0f), class_1322.class_1323.field_6328);
    }

    private void sendCloudMinionPacket(class_1657 player, CloudMinion cloudMinionRight, CloudMinion cloudMinionLeft) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!player.method_37908().field_9236) {
                PacketDistributor.sendToPlayer(serverPlayer, new CloudMinionPacket(player.method_5628(), cloudMinionRight.method_5628(), cloudMinionLeft.method_5628()), new class_8710[0]);
            }
        }
    }

    private boolean shouldSyncBetweenClients() {
        return this.shouldSyncBetweenClients;
    }

    private void setShouldSyncBetweenClients(boolean shouldSyncBetweenClients) {
        this.shouldSyncBetweenClients = shouldSyncBetweenClients;
    }

    public SyncPacket getSyncPacket(int entityID, String key, INBTSynchable.Type type, Object value) {
        return new AetherPlayerSyncPacket(entityID, key, type, value);
    }
}

